/*
 * Decompiled with CFR 0.152.
 */
package io.globalcopy.authentication.config.models;

import io.globalcopy.authentication.config.models.GlobalCopyPerm;
import io.globalcopy.authentication.config.models.GlobalCopyUser;
import jakarta.persistence.Basic;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Set;
import org.hibernate.annotations.CreationTimestamp;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

@Entity
@Table(name="global_copy_user")
public class GlobalCopyUser
implements UserDetails {
    @Id
    @GeneratedValue
    private Long id;
    @Basic
    @Column(unique=true)
    private String username;
    @Basic
    @Column(unique=true)
    private String email;
    @Basic
    private String pwhash;
    @Enumerated(value=EnumType.STRING)
    GlobalCopyPerm perm;
    @ElementCollection(targetClass=GlobalCopyPerm.class)
    @Enumerated
    private Set<GlobalCopyPerm> grantedAuthorities;
    @Basic
    private boolean isEnabled;
    @CreationTimestamp
    LocalDateTime dateCreated;
    @CreationTimestamp
    LocalDateTime lastUpdated;
    String pwRecoveryToken;
    LocalDateTime pwRecoveryTokenExpiration;

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.grantedAuthorities.stream().map(GlobalCopyPerm::getGrantedAuthority).toList();
    }

    public void addAuthority(GlobalCopyPerm perm) {
        this.grantedAuthorities.add(perm);
    }

    public void removeAuthority(GlobalCopyPerm perm) {
        this.grantedAuthorities.remove(perm);
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.pwhash;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setEmail(String username) {
        this.email = this.email;
    }

    public void setPwhash(String pwhash) {
        this.pwhash = pwhash;
    }

    public boolean isAccountNonExpired() {
        return true;
    }

    public boolean isAccountNonLocked() {
        return true;
    }

    public boolean isCredentialsNonExpired() {
        return true;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public static GlobalCopyUserBuilder builder() {
        return new GlobalCopyUserBuilder();
    }

    public GlobalCopyUser() {
    }

    public GlobalCopyUser(Long id, String username, String email, String pwhash, GlobalCopyPerm perm, Set<GlobalCopyPerm> grantedAuthorities, boolean isEnabled, LocalDateTime dateCreated, LocalDateTime lastUpdated, String pwRecoveryToken, LocalDateTime pwRecoveryTokenExpiration) {
        this.id = id;
        this.username = username;
        this.email = email;
        this.pwhash = pwhash;
        this.perm = perm;
        this.grantedAuthorities = grantedAuthorities;
        this.isEnabled = isEnabled;
        this.dateCreated = dateCreated;
        this.lastUpdated = lastUpdated;
        this.pwRecoveryToken = pwRecoveryToken;
        this.pwRecoveryTokenExpiration = pwRecoveryTokenExpiration;
    }

    public String getEmail() {
        return this.email;
    }

    public String getPwRecoveryToken() {
        return this.pwRecoveryToken;
    }

    public void setPwRecoveryToken(String pwRecoveryToken) {
        this.pwRecoveryToken = pwRecoveryToken;
    }

    public LocalDateTime getPwRecoveryTokenExpiration() {
        return this.pwRecoveryTokenExpiration;
    }

    public void setPwRecoveryTokenExpiration(LocalDateTime pwRecoveryTokenExpiration) {
        this.pwRecoveryTokenExpiration = pwRecoveryTokenExpiration;
    }
}

