/*
 * Decompiled with CFR 0.152.
 */
package io.globalcopy.authentication.config.wrappers;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringEscapeUtils;

public class HttpServletSanitizedParamRequest
extends HttpServletRequestWrapper {
    private final Map<String, String[]> sanitizedMap;

    public HttpServletSanitizedParamRequest(HttpServletRequest request) {
        super(request);
        this.sanitizedMap = request.getParameterMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, stringEntry -> (String[])Arrays.stream((String[])stringEntry.getValue()).map(StringEscapeUtils::escapeHtml4).toArray(String[]::new)));
    }

    public Map<String, String[]> getParameterMap() {
        return this.sanitizedMap;
    }

    public String[] getParameterValues(String name) {
        return Optional.ofNullable((String[])this.getParameterMap().get(name)).map(values -> Arrays.copyOf(values, ((String[])values).length)).orElse(null);
    }

    public String getParameter(String name) {
        return Optional.ofNullable(this.getParameterValues(name)).map(values -> values[0]).orElse(null);
    }
}

