/*
 * Decompiled with CFR 0.152.
 */
package io.globalcopy.client;

import io.globalcopy.client.CopyEntry.CopyEntry;
import io.globalcopy.client.CopyRetriever.CopyRetriever;
import io.globalcopy.client.FrontEnd.CopyEntryViewer;
import io.globalcopy.client.RequestSender;
import java.util.ArrayList;

public class ClipboardSync
extends Thread {
    Integer SYNC_REFRESH_TIME = 1000;
    RequestSender requester;
    CopyRetriever retriever;
    boolean syncEnabled = false;
    private CopyEntryViewer viewer;
    private String appPropsPath;

    public ClipboardSync(RequestSender requestor, CopyRetriever retriever) {
        this.retriever = retriever;
        this.requester = requestor;
        this.checkServerData();
    }

    private void checkServerData() {
        try {
            ArrayList lastSession = this.requester.sendGetAllReq();
            if (!lastSession.isEmpty()) {
                this.retriever.setClipboard(lastSession);
            }
        }
        catch (Throwable e) {
            if (e.getMessage().contains("HMAC verification failed")) {
                this.viewer = new CopyEntryViewer();
                this.viewer.setRequestorRetriever(this.requester, this.retriever);
                this.viewer.openHmacDialouge();
            }
            throw new RuntimeException(e);
        }
    }

    public void initViewer() {
        this.viewer = new CopyEntryViewer();
        this.viewer.setRequestorRetriever(this.requester, this.retriever);
        this.viewer.createUI();
        this.viewer.setVisible(true);
    }

    public void checkSync() {
        CopyEntry recentRequest;
        block8: {
            recentRequest = null;
            try {
                recentRequest = this.requester.sendGetReq();
            }
            catch (Exception e) {
                if (!e.getMessage().contains("HMAC verification failed") || this.viewer != null) break block8;
                this.viewer = new CopyEntryViewer();
                this.viewer.setRequestorRetriever(this.requester, this.retriever);
                this.viewer.openHmacDialouge();
            }
        }
        if (recentRequest == null) {
            System.out.println("request failed, retrying");
            return;
        }
        if (!this.retriever.getLastentry().compareTo(recentRequest) && this.retriever.getLastentry().getTimestamp().isBefore(recentRequest.timestamp)) {
            this.retriever.addNewClipboardEntry(recentRequest);
        }
        if (this.retriever.fixDesync()) {
            try {
                this.requester.sendPostReq(this.retriever.getLastentry());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (this.viewer != null) {
            this.viewer.updateTableData();
        }
    }

    @Override
    public void run() {
        while (this.syncEnabled) {
            try {
                this.checkSync();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            try {
                Thread.sleep(this.SYNC_REFRESH_TIME.intValue());
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void toggleSync() {
        this.syncEnabled = !this.syncEnabled;
    }

    public CopyRetriever getRetriever() {
        return this.retriever;
    }

    public RequestSender getRequestor() {
        return this.requester;
    }
}

