/*
 * Decompiled with CFR 0.152.
 */
package io.globalcopy.client.CopyRetriever;

import io.globalcopy.client.CopyEntry.CopyEntry;
import io.globalcopy.client.CopyEntry.CopyTag;
import io.globalcopy.client.CopyEntry.Seralizer;
import io.globalcopy.client.CopyRetriever.CopyRetriever;
import io.globalcopy.client.CopyRetriever.WindowsLinuxRetriever;
import io.globalcopy.client.PropertyManager;
import io.globalcopy.client.conversion.ParseImg;
import io.globalcopy.client.conversion.TransferableImage;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jnativehook.GlobalScreen;
import org.jnativehook.NativeHookException;
import org.jnativehook.keyboard.NativeKeyEvent;
import org.jnativehook.keyboard.NativeKeyListener;

public class WindowsLinuxRetriever
implements CopyRetriever,
NativeKeyListener {
    private ArrayList<CopyEntry> entryList;
    private String author;
    boolean ctrlPressed = false;
    boolean cPressed = false;
    int numSelection = 0;
    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
    int ENTRY_LIMIT = 5;
    ParseImg pi = new ParseImg();

    public WindowsLinuxRetriever() {
        this.author = PropertyManager.getAuthor();
        this.entryList = new ArrayList();
        CopyEntry value = null;
        try {
            Transferable t = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
            if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                value = new CopyEntry(this.author, OffsetDateTime.now(), (String)this.clipboard.getData(DataFlavor.stringFlavor));
                value.setTag(CopyTag.STRING);
            }
            if (t.isDataFlavorSupported(DataFlavor.imageFlavor)) {
                value = new CopyEntry(this.author, OffsetDateTime.now(), (String)this.clipboard.getData(DataFlavor.stringFlavor));
                value.setTag(CopyTag.IMAGE);
            }
            this.entryList.add(value);
        }
        catch (UnsupportedFlavorException | IOException t) {
            // empty catch block
        }
        if (value == null) {
            value = new CopyEntry(this.author, OffsetDateTime.now(), "staring..");
            this.addNewClipboardEntry(value);
            this.entryList.add(value);
        }
        Logger logger = Logger.getLogger(GlobalScreen.class.getPackage().getName());
        logger.setLevel(Level.OFF);
        logger.setUseParentHandlers(false);
        try {
            GlobalScreen.registerNativeHook();
        }
        catch (NativeHookException ex) {
            System.err.println("There was a problem registering the native hook.");
            System.err.println(ex.getMessage());
            System.exit(1);
        }
        GlobalScreen.addNativeKeyListener((NativeKeyListener)this);
    }

    public WindowsLinuxRetriever(String filepath) {
        Seralizer s = new Seralizer();
        try {
            this.entryList = (ArrayList)s.deserialize(filepath);
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public ArrayList<CopyEntry> getClipboard() {
        return this.entryList;
    }

    public void setClipboard(ArrayList<CopyEntry> data) {
        this.entryList = data;
        this.setClipboardToEntry((CopyEntry)this.entryList.get(this.entryList.size() - 1));
    }

    public void setClipboardToEntry(CopyEntry data) {
        StringSelection selection = null;
        try {
            switch (1.$SwitchMap$io$globalcopy$client$CopyEntry$CopyTag[data.tag.ordinal()]) {
                case 1: {
                    selection = new TransferableImage(this.pi.convertToImage(data.data));
                    break;
                }
                case 2: {
                    selection = new StringSelection(data.data);
                }
            }
            this.clipboard.setContents(selection, selection);
        }
        catch (Throwable throwable) {
            this.clipboard.setContents(selection, selection);
            throw throwable;
        }
    }

    public void addNewClipboardEntry(CopyEntry entry) {
        this.entryList.add(entry);
        if (this.entryList.size() > this.ENTRY_LIMIT) {
            this.entryList.remove(0);
        }
        this.setClipboardToEntry(entry);
    }

    public CopyEntry getLastentry() {
        return (CopyEntry)this.entryList.get(this.entryList.size() - 1);
    }

    public CopyEntry getCopyEntryAt(int index) {
        return (CopyEntry)this.entryList.get(index);
    }

    public boolean fixDesync() {
        try {
            Transferable t = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
            CopyEntry newEntry = new CopyEntry(this.author, OffsetDateTime.now(), null);
            if (t != null) {
                if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    newEntry.data = (String)this.clipboard.getData(DataFlavor.stringFlavor);
                    newEntry.tag = CopyTag.STRING;
                    return this.verifyData(newEntry);
                }
                if (t.isDataFlavorSupported(DataFlavor.imageFlavor)) {
                    newEntry.data = this.pi.convertToString((BufferedImage)this.clipboard.getData(DataFlavor.imageFlavor));
                    newEntry.tag = CopyTag.IMAGE;
                    return this.verifyData(newEntry);
                }
            }
        }
        catch (UnsupportedFlavorException | IOException exception) {
            // empty catch block
        }
        return false;
    }

    public boolean verifyData(CopyEntry entry) {
        if (!this.existsinEntryList(entry.data)) {
            this.addNewClipboardEntry(entry);
            return true;
        }
        return false;
    }

    public boolean existsinEntryList(String dataCheck) {
        for (CopyEntry entry : this.entryList) {
            if (!entry.data.equals(dataCheck)) continue;
            return true;
        }
        return false;
    }

    public void nativeKeyTyped(NativeKeyEvent nativeKeyEvent) {
    }

    public void nativeKeyPressed(NativeKeyEvent nativeKeyEvent) {
        String keyName = NativeKeyEvent.getKeyText((int)nativeKeyEvent.getKeyCode());
        if (keyName.equals("Ctrl")) {
            this.ctrlPressed = true;
        }
        if (keyName.equals("C")) {
            this.cPressed = true;
        }
        if (this.ctrlPressed) {
            try {
                int index = Integer.parseInt(keyName);
                if (index > 0 && this.ENTRY_LIMIT >= index) {
                    this.numSelection = this.entryList.size() - index;
                    CopyEntry entry = (CopyEntry)this.entryList.get(this.numSelection);
                    this.setClipboardToEntry(entry);
                }
            }
            catch (NumberFormatException index) {
                // empty catch block
            }
        }
        if (nativeKeyEvent.getKeyCode() == 1) {
            try {
                GlobalScreen.unregisterNativeHook();
            }
            catch (NativeHookException nativeHookException) {
                nativeHookException.printStackTrace();
            }
        }
    }

    public void nativeKeyReleased(NativeKeyEvent nativeKeyEvent) {
        if (NativeKeyEvent.getKeyText((int)nativeKeyEvent.getKeyCode()).equals("Ctrl")) {
            this.ctrlPressed = false;
        }
        if (NativeKeyEvent.getKeyText((int)nativeKeyEvent.getKeyCode()).equals("C")) {
            this.cPressed = false;
        }
    }
}

