/*
 * Decompiled with CFR 0.152.
 */
package io.globalcopy.client.FrontEnd;

import io.globalcopy.client.ClipboardSync;
import io.globalcopy.client.CopyEntry.CopyEntry;
import io.globalcopy.client.CopyEntry.CopyTag;
import io.globalcopy.client.CopyRetriever.CopyRetriever;
import io.globalcopy.client.CopyRetriever.WindowsLinuxRetriever;
import io.globalcopy.client.PropertyManager;
import io.globalcopy.client.RequestSender;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.io.File;
import java.time.OffsetDateTime;
import java.util.Arrays;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class ClientMain
extends JFrame {
    private final JTextField usernamefield;
    private final JTextField emailField;
    private final JPasswordField passwordField;
    private final JPasswordField passwordConfirmField;
    private final JLabel emailText;
    private final JLabel usernameText;
    private final JLabel confirmText;
    private final JLabel passwordText;
    private final JRadioButton toggleSignUp;
    private final JCheckBox debugToggle;
    private final JTextField debugLink;
    private final JLabel statusLabel;

    public ClientMain() {
        this.setDefaultCloseOperation(2);
        JButton enterForUI = new JButton("Enter");
        enterForUI.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        JLabel imgeIcon = new JLabel("GlobalCopy");
        this.usernamefield = new JTextField(5);
        this.emailField = new JTextField(5);
        this.passwordField = new JPasswordField(5);
        this.passwordConfirmField = new JPasswordField(5);
        this.emailText = new JLabel("Email");
        this.usernameText = new JLabel("Username");
        this.confirmText = new JLabel("Confirm Password");
        this.passwordText = new JLabel("Password");
        this.statusLabel = new JLabel();
        JRadioButton toggleLogin = new JRadioButton("Log In");
        this.toggleSignUp = new JRadioButton("Sign Up");
        ButtonGroup toggleGroup = new ButtonGroup();
        toggleGroup.add(this.toggleSignUp);
        toggleGroup.add(toggleLogin);
        this.toggleSignUp.setSelected(true);
        this.toggleSignUp.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        toggleLogin.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.debugToggle = new JCheckBox("Debug Mode");
        this.debugToggle.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.debugLink = new JTextField(5);
        this.debugLink.setVisible(false);
        this.debugLink.setToolTipText("Redirect Link");
        this.setPreferredSize(new Dimension(478, 538));
        this.setLayout(null);
        this.add((Component)enterForUI);
        this.add((Component)imgeIcon);
        this.add((Component)this.usernamefield);
        this.add((Component)this.emailField);
        this.add((Component)this.passwordField);
        this.add((Component)this.passwordConfirmField);
        this.add((Component)this.emailText);
        this.add((Component)this.usernameText);
        this.add((Component)this.confirmText);
        this.add((Component)this.passwordText);
        this.add((Component)toggleLogin);
        this.add((Component)this.toggleSignUp);
        this.add((Component)this.debugToggle);
        this.add((Component)this.debugLink);
        this.add((Component)this.statusLabel);
        enterForUI.setBounds(100, 380, 100, 20);
        imgeIcon.setBounds(185, 65, 100, 25);
        this.usernamefield.setBounds(100, 210, 100, 25);
        this.emailField.setBounds(260, 210, 100, 25);
        this.passwordConfirmField.setBounds(260, 290, 100, 25);
        this.passwordField.setBounds(100, 280, 100, 25);
        this.emailText.setBounds(260, 175, 100, 25);
        this.usernameText.setBounds(100, 175, 100, 25);
        this.statusLabel.setBounds(90, 160, 400, 25);
        this.confirmText.setBounds(260, 250, 115, 30);
        this.passwordText.setBounds(100, 250, 100, 25);
        toggleLogin.setBounds(100, 340, 145, 25);
        this.toggleSignUp.setBounds(260, 340, 100, 25);
        this.debugToggle.setBounds(20, 450, 100, 25);
        this.debugLink.setBounds(130, 450, 100, 25);
        this.pack();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException exception) {
            // empty catch block
        }
        this.setVisible(true);
        this.attemptLoginWithPropertyFile();
    }

    private void attemptLoginWithPropertyFile() {
        File f = new File("user.properties");
        if (f.exists() && !f.isDirectory()) {
            PropertyManager.loadPropertyFile((String)"user.properties");
            if (PropertyManager.getKey() != null && PropertyManager.getAuthor() != null) {
                if (this.processLogin()) {
                    this.dispose();
                    this.setVisible(false);
                } else {
                    this.statusLabel.setText("This device is no longer valid, please Log in again.");
                    this.statusLabel.setForeground(Color.MAGENTA);
                    f.delete();
                }
            }
        }
    }

    private void submitConnection() {
        if (this.verifyRequiredFields()) {
            if (this.debugToggle.isSelected()) {
                PropertyManager.generateNewPropertyFile((String)new File("user.properties").getPath(), (String)this.usernamefield.getText(), (String)this.debugLink.getText(), (String)new String(this.passwordField.getPassword()), (String)this.emailField.getText());
            } else {
                PropertyManager.generateNewPropertyFile((String)new File("user.properties").getPath(), (String)this.usernamefield.getText(), (String)"https://stage.globalcopy.io", (String)new String(this.passwordField.getPassword()), (String)this.emailField.getText());
            }
            if (this.toggleSignUp.isSelected()) {
                if (this.processSignUp()) {
                    this.dispose();
                }
            } else if (this.processLogin()) {
                this.dispose();
            } else {
                PropertyManager.deletePropertyFile();
            }
        }
    }

    private boolean processSignUp() {
        try {
            RequestSender sender = new RequestSender();
            int response = sender.sendCreateRequest();
            if (response == 403) {
                this.statusLabel.setText("This Username is in use");
                this.statusLabel.setForeground(Color.MAGENTA);
                return false;
            }
            CopyEntry firstEntry = new CopyEntry(PropertyManager.getAuthor(), OffsetDateTime.now(), "init");
            firstEntry.tag = CopyTag.STRING;
            sender.sendPostReq(firstEntry);
            PropertyManager.loadPropertyFile((String)new File("user.properties").getPath());
            this.setupClipboardSync(sender);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    private void setupClipboardSync(RequestSender sender) {
        ClipboardSync cbs = new ClipboardSync(sender, (CopyRetriever)new WindowsLinuxRetriever());
        cbs.initViewer();
        cbs.toggleSync();
        cbs.start();
    }

    private boolean processLogin() {
        try {
            RequestSender sender = new RequestSender();
            int response = sender.sendLoginRequest();
            if (response == 403) {
                this.statusLabel.setText("The username/password is invalid");
                this.statusLabel.setForeground(Color.RED);
                return false;
            }
            PropertyManager.loadPropertyFile((String)new File("user.properties").getPath());
            this.setupClipboardSync(sender);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    private boolean verifyRequiredFields() {
        boolean valid = true;
        if (this.usernamefield.getText().isEmpty()) {
            this.usernameText.setForeground(Color.RED);
            valid = false;
        } else {
            this.usernameText.setForeground(Color.BLACK);
        }
        if (this.toggleSignUp.isSelected()) {
            if (this.emailField.getText().isEmpty()) {
                this.emailText.setForeground(Color.RED);
                valid = false;
            } else {
                this.emailText.setForeground(Color.BLACK);
            }
            if (this.passwordConfirmField.getPassword().length <= 0) {
                this.confirmText.setForeground(Color.RED);
                valid = false;
            } else {
                this.confirmText.setForeground(Color.BLACK);
            }
        }
        if (this.passwordField.getPassword().length == 0) {
            this.passwordText.setForeground(Color.RED);
            valid = false;
        } else {
            this.passwordText.setForeground(Color.BLACK);
        }
        if (!Arrays.equals(this.passwordConfirmField.getPassword(), this.passwordField.getPassword()) && this.passwordConfirmField.getPassword().length > 0 && this.passwordField.getPassword().length > 0 && this.toggleSignUp.isSelected()) {
            this.passwordText.setForeground(Color.MAGENTA);
            this.confirmText.setForeground(Color.MAGENTA);
            valid = false;
        }
        return valid;
    }

    private void toggleSignUpFields() {
        this.confirmText.setVisible(this.toggleSignUp.isSelected());
        this.emailField.setVisible(this.toggleSignUp.isSelected());
        this.emailText.setVisible(this.toggleSignUp.isSelected());
        this.passwordConfirmField.setVisible(this.toggleSignUp.isSelected());
    }

    public static void main(String[] args) {
        new ClientMain();
    }
}

