/*
 * Decompiled with CFR 0.152.
 */
package io.globalcopy.client.FrontEnd;

import io.globalcopy.client.CopyEntry.CopyEntry;
import io.globalcopy.client.CopyRetriever.CopyRetriever;
import io.globalcopy.client.FrontEnd.CopyEntryViewer;
import io.globalcopy.client.PropertyManager;
import io.globalcopy.client.RequestSender;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.ActionListener;
import java.awt.event.WindowStateListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;

public class CopyEntryViewer
extends JFrame {
    private JTextField authorField;
    private RequestSender requestor;
    private CopyRetriever retriever;
    private JButton searchButton;
    private JTable resultsTable;
    private DefaultTableModel tableModel;
    private TrayIcon trayIcon;
    private SystemTray tray;

    public void setRequestorRetriever(RequestSender requestSender, CopyRetriever copyRetriever) {
        this.requestor = requestSender;
        this.retriever = copyRetriever;
    }

    public void createUI() {
        this.setTitle("Copy Entry Viewer");
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (SystemTray.isSupported()) {
            this.tray = SystemTray.getSystemTray();
            Image image = Toolkit.getDefaultToolkit().getImage("globe-clipboard.png");
            1 exitListener = new /* Unavailable Anonymous Inner Class!! */;
            PopupMenu popup = new PopupMenu();
            MenuItem defaultItem = new MenuItem("Exit");
            defaultItem.addActionListener((ActionListener)exitListener);
            popup.add(defaultItem);
            defaultItem = new MenuItem("Open");
            defaultItem.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
            popup.add(defaultItem);
            this.trayIcon = new TrayIcon(image, "Global Copy", popup);
            this.trayIcon.setImageAutoSize(true);
        }
        this.setDefaultCloseOperation(3);
        this.addWindowStateListener((WindowStateListener)new /* Unavailable Anonymous Inner Class!! */);
        this.setIconImage(Toolkit.getDefaultToolkit().getImage("globe-clipboard.png"));
        this.setSize(600, 400);
        this.setLayout((LayoutManager)new BorderLayout());
        this.authorField = new JTextField();
        this.add((Component)this.authorField, (Object)"North");
        this.tableModel = new DefaultTableModel();
        this.tableModel.addColumn("Author");
        this.tableModel.addColumn("Data");
        this.tableModel.addColumn("Timestamp");
        for (CopyEntry entry : this.retriever.getClipboard()) {
            this.tableModel.addRow(new Object[]{entry.author, entry.data, entry.timestamp});
        }
        this.resultsTable = new JTable(this.tableModel);
        this.add((Component)new JScrollPane(this.resultsTable), (Object)"Center");
        JButton handleHmac = new JButton("Update Encryption");
        handleHmac.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.add((Component)handleHmac, (Object)"South");
    }

    public void openHmacDialouge() {
        JFrame hmachFrame = new JFrame();
        JButton enterButton = new JButton("Enter");
        JTextField textField = new JTextField(5);
        JLabel newKeyText = new JLabel("Enter New Key");
        JLabel currentKeyTooltip = new JLabel("Current Key:");
        JLabel hmacReplaceable = new JLabel(PropertyManager.getHmac());
        enterButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        hmachFrame.setLayout(null);
        hmachFrame.add(enterButton);
        hmachFrame.add(textField);
        hmachFrame.add(newKeyText);
        hmachFrame.add(currentKeyTooltip);
        hmachFrame.add(hmacReplaceable);
        enterButton.setBounds(150, 140, 105, 25);
        textField.setBounds(50, 140, 100, 25);
        newKeyText.setBounds(50, 105, 180, 25);
        currentKeyTooltip.setBounds(50, 75, 100, 25);
        hmacReplaceable.setBounds(150, 75, 100, 25);
        hmachFrame.setSize(300, 270);
        hmachFrame.setLocation(this.getX() + this.getWidth() / 4, this.getY() + this.getHeight() / 4);
        hmachFrame.setVisible(true);
    }

    public void updateTableData() {
        this.tableModel.setRowCount(0);
        for (CopyEntry entry : this.retriever.getClipboard()) {
            this.tableModel.addRow(new Object[]{entry.author, entry.data, entry.timestamp});
        }
        this.tableModel.fireTableDataChanged();
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(CopyEntryViewer::new);
    }
}

