/*
 * Decompiled with CFR 0.152.
 */
package io.globalcopy.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.globalcopy.client.CopyEntry.CopyEntry;
import io.globalcopy.client.PropertyManager;
import io.globalcopy.security.Encryptor;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.crypto.spec.IvParameterSpec;
import org.apache.hc.core5.net.URIBuilder;
import org.springframework.http.HttpStatus;

public class RequestSender {
    private HttpClient client = HttpClient.newHttpClient();
    private Encryptor encryptor;
    private String token;
    private String author;
    private boolean validCredentials = true;
    private String link = "http://localhost:8080";
    private ObjectMapper mapper = new ObjectMapper().registerModule((Module)new JavaTimeModule()).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS).disable(DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE);

    public RequestSender(HttpClient cli, String token, Encryptor encryptor, String author) {
        this.client = cli;
        this.encryptor = encryptor;
        this.encryptor.cycleEncryption();
        this.token = token;
        this.author = author;
    }

    public RequestSender() {
        this.author = PropertyManager.getAuthor();
        this.encryptor = new Encryptor(new IvParameterSpec(new byte[16]));
        this.link = PropertyManager.getLink();
    }

    public int sendCreateRequest() throws IOException, InterruptedException, URISyntaxException {
        HttpRequest req = HttpRequest.newBuilder().uri(new URIBuilder(URI.create(this.link + "/api/v0/signup")).addParameter("username", PropertyManager.getAuthor()).addParameter("email", PropertyManager.getEmail()).addParameter("pw1", PropertyManager.getPassword()).addParameter("pw2", PropertyManager.getPassword()).build()).method("POST", HttpRequest.BodyPublishers.noBody()).build();
        HttpResponse<String> res = this.client.send(req, HttpResponse.BodyHandlers.ofString());
        this.token = "Bearer " + res.headers().firstValue("Authorization").orElse("");
        return res.statusCode();
    }

    public int sendGenerateReq() throws IOException, InterruptedException {
        HttpRequest req = HttpRequest.newBuilder().uri(URI.create(this.link + "/api/v0/generate")).GET().build();
        return this.client.send(req, HttpResponse.BodyHandlers.ofString()).statusCode();
    }

    public CopyEntry sendGetReq() throws Exception {
        HttpRequest req = HttpRequest.newBuilder().uri(URI.create(this.link + "/api/v0/history/1")).method("GET", HttpRequest.BodyPublishers.noBody()).header("Authorization", this.token).build();
        HttpResponse<String> res = this.client.send(req, HttpResponse.BodyHandlers.ofString());
        List temp = (List)this.mapper.readValue(res.body(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        CopyEntry entry = null;
        if (!temp.isEmpty()) {
            entry = (CopyEntry)temp.get(0);
            this.encryptor.cycleEncryption();
            entry.setData(this.encryptor.decryptData(entry.data));
            return entry;
        }
        return entry;
    }

    public ArrayList<CopyEntry> sendGetAllReq() throws IOException, InterruptedException {
        HttpRequest req = HttpRequest.newBuilder().uri(URI.create(this.link + "/api/v0/history")).method("GET", HttpRequest.BodyPublishers.noBody()).header("Authorization", this.token).build();
        HttpResponse<String> res = this.client.send(req, HttpResponse.BodyHandlers.ofString());
        if (res.body().isEmpty()) {
            return new ArrayList<CopyEntry>();
        }
        List temp = (List)this.mapper.readValue(res.body(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        this.encryptor.cycleEncryption();
        for (CopyEntry entry : temp) {
            try {
                entry.data = this.encryptor.decryptData(entry.data);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return (ArrayList)temp;
    }

    public String sendHeadReq() throws IOException, InterruptedException {
        HttpRequest req = HttpRequest.newBuilder().uri(URI.create(this.link + "/api/v0/hello")).method("HEAD", HttpRequest.BodyPublishers.noBody()).header("Authorization", this.token).build();
        HttpResponse<String> res = this.client.send(req, HttpResponse.BodyHandlers.ofString());
        Optional<String> lastModifiedHeader = res.headers().firstValue("last-modified");
        OffsetDateTime lastModified = (OffsetDateTime)this.mapper.readValue((String)lastModifiedHeader.orElse(null), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        return lastModified.toString();
    }

    public boolean sendPostReq(CopyEntry entry) throws Exception {
        this.encryptor.cycleEncryption();
        CopyEntry toSend = CopyEntry.builder().timestamp(entry.timestamp).author(this.author).data(this.encryptor.encryptData(entry.data)).tag(entry.tag).build();
        String requestBody = this.mapper.writeValueAsString((Object)toSend);
        HttpRequest req = HttpRequest.newBuilder().uri(URI.create(this.link + "/api/v0/post")).POST(HttpRequest.BodyPublishers.ofString(requestBody)).header("Content-Type", "application/json").header("Accept", "application/json").header("Authorization", this.token).build();
        HttpResponse<String> res = this.client.send(req, HttpResponse.BodyHandlers.ofString());
        return res.statusCode() == HttpStatus.CREATED.value();
    }

    public int sendLoginRequest() throws IOException, InterruptedException, URISyntaxException {
        HttpRequest req = HttpRequest.newBuilder().uri(new URIBuilder(URI.create(this.link + "/api/v0/login/process")).addParameter("username", PropertyManager.getAuthor()).addParameter("password", PropertyManager.getPassword()).addParameter("pw2", PropertyManager.getPassword()).build()).POST(HttpRequest.BodyPublishers.noBody()).header("Content-Type", "application/json").header("Accept", "application/json").build();
        HttpResponse<String> res = this.client.send(req, HttpResponse.BodyHandlers.ofString());
        this.token = "Bearer " + res.headers().firstValue("Authorization").orElse("");
        return res.statusCode();
    }

    public void sendClearReq() throws IOException, InterruptedException {
        HttpRequest req = HttpRequest.newBuilder().uri(URI.create(this.link + "/api/v0/history/-1")).method("DELETE", HttpRequest.BodyPublishers.noBody()).header("Authorization", this.token).build();
        HttpResponse<String> res = this.client.send(req, HttpResponse.BodyHandlers.ofString());
    }

    public void sendPostAllReq(ArrayList<CopyEntry> toServer) {
        for (CopyEntry entry : toServer) {
            try {
                this.sendPostReq(entry);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

