/*
 * Decompiled with CFR 0.152.
 */
package io.globalcopy.controllers;

import io.globalcopy.authentication.config.models.GlobalCopyUser;
import io.globalcopy.authentication.config.repositories.UserRepository;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import java.security.SecureRandom;
import java.time.LocalDateTime;
import java.util.Base64;
import java.util.Optional;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PasswordRecoveryController {
    private final PasswordEncoder passwordEncoder;
    private final UserRepository userRepo;
    String emailRegex = "^[a-zA-Z0-9_+&*-]+(?:\\.[a-zA-Z0-9_+&*-]+)*@(?:[a-zA-Z0-9-]+\\.)+[a-zA-Z]{2,7}$";
    Pattern pat = Pattern.compile(this.emailRegex);
    @Autowired
    private JavaMailSender mailSender;
    private String domain = "stage.globalcopy.io";

    @GetMapping(value={"/password-recovery"})
    public String about() {
        return "password-recovery";
    }

    @PostMapping(value={"/api/v0/recover-password"})
    public ModelAndView recoverPassword(@RequestParam(value="email") String email) {
        Optional requestedUser = this.userRepo.findByEmail(email);
        if (this.pat.matcher(email).matches() && requestedUser.isPresent()) {
            this.sendRecoveryEmail(requestedUser);
            return new ModelAndView("recover-email-sent");
        }
        return new ModelAndView("failed-recovery");
    }

    @GetMapping(value={"/change-password"})
    public ModelAndView validateToken(@RequestParam String token) {
        Optional user = this.userRepo.findBypwRecoveryToken(token);
        if (user.isPresent() && LocalDateTime.now().isBefore(((GlobalCopyUser)user.get()).getPwRecoveryTokenExpiration())) {
            return new ModelAndView("change-password");
        }
        return new ModelAndView("failed-recovery");
    }

    @PostMapping(value={"/api/v0/reset-password"})
    public ModelAndView resetPassword(@RequestParam(value="newPassword") String newPassword, @RequestParam(value="confirmPassword") String confirmPassword, @RequestParam(value="token") String token) {
        System.out.println("entered api call");
        ModelAndView modelAndView = new ModelAndView();
        Optional user = this.userRepo.findBypwRecoveryToken(token);
        System.out.println("User: " + String.valueOf(user));
        System.out.println("Token: " + token);
        if (user.isEmpty() || !LocalDateTime.now().isBefore(((GlobalCopyUser)user.get()).getPwRecoveryTokenExpiration())) {
            modelAndView.addObject("message", (Object)"Invalid or expired token.");
            modelAndView.setViewName("expired-token");
            return modelAndView;
        }
        if (!newPassword.equals(confirmPassword)) {
            modelAndView.addObject("message", (Object)"Passwords do not match.");
            modelAndView.setViewName("change-password");
            return modelAndView;
        }
        ((GlobalCopyUser)user.get()).setPwhash(this.passwordEncoder.encode((CharSequence)newPassword));
        ((GlobalCopyUser)user.get()).setPwRecoveryToken(null);
        ((GlobalCopyUser)user.get()).setPwRecoveryTokenExpiration(null);
        this.userRepo.save((Object)((GlobalCopyUser)user.get()));
        modelAndView.addObject("message", (Object)"Password successfully updated.");
        modelAndView.setViewName("login");
        return modelAndView;
    }

    private String generateToken() {
        SecureRandom random = new SecureRandom();
        byte[] values = new byte[24];
        random.nextBytes(values);
        return Base64.getUrlEncoder().withoutPadding().encodeToString(values);
    }

    private void sendRecoveryEmail(Optional<GlobalCopyUser> user) {
        String token = this.generateToken();
        String resetLink = this.domain + "/change-password?token=" + token;
        user.get().setPwRecoveryToken(token);
        user.get().setPwRecoveryTokenExpiration(LocalDateTime.now().plusMinutes(10L));
        this.userRepo.save((Object)user.get());
        MimeMessage message = this.mailSender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(message);
        try {
            helper.setTo(user.get().getEmail());
            helper.setSubject("Password Recovery");
            helper.setText("Click the link to reset your password: " + resetLink);
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
        this.mailSender.send(message);
    }

    public PasswordRecoveryController(PasswordEncoder passwordEncoder, UserRepository userRepo) {
        this.passwordEncoder = passwordEncoder;
        this.userRepo = userRepo;
    }
}

