/*
 * Decompiled with CFR 0.152.
 */
package io.globalcopy.rest;

import io.globalcopy.authentication.config.dtos.JwtAuthenticationResponse;
import io.globalcopy.authentication.config.dtos.SignInRequest;
import io.globalcopy.authentication.config.dtos.SignUpRequest;
import io.globalcopy.authentication.config.managers.AuthenticationService;
import io.globalcopy.authentication.config.models.GlobalCopyUser;
import io.globalcopy.authentication.config.repositories.UserRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v0"})
public class LoginREST {
    private static final Logger log = LoggerFactory.getLogger(LoginREST.class);
    private final UserRepository userRepo;
    private final AuthenticationService authService;

    @GetMapping(value={"/login/generate"})
    public ResponseEntity<Void> generateUser() {
        GlobalCopyUser user1 = new GlobalCopyUser();
        user1.setUsername("popo");
        user1.setPwhash("password1234");
        this.userRepo.save((Object)user1);
        HttpHeaders headers = new HttpHeaders();
        return new ResponseEntity(null, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.CREATED);
    }

    @PostMapping(value={"/login/process"})
    public ResponseEntity<JwtAuthenticationResponse> handleLogin(@RequestParam(value="username") String username, @RequestParam(value="password") String password) {
        SignInRequest srq = new SignInRequest(username, password);
        JwtAuthenticationResponse jwtres = this.authService.signin(srq);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Authorization", jwtres.getToken());
        return new ResponseEntity((Object)jwtres, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.CREATED);
    }

    @PostMapping(value={"/signup"})
    public ResponseEntity<JwtAuthenticationResponse> handleSignup(@RequestParam(value="username") String username, @RequestParam(value="email") String email, @RequestParam(value="pw1") String password1, @RequestParam(value="pw2") String password2) {
        if (null == password1 || !password1.equals(password2)) {
            throw new IllegalArgumentException("Re-entered password does not match provided password");
        }
        try {
            SignUpRequest srq = new SignUpRequest(username, email, password1);
            JwtAuthenticationResponse jwres = this.authService.signup(srq);
            HttpHeaders headers = new HttpHeaders();
            headers.add("Authorization", jwres.getToken());
            return new ResponseEntity((Object)jwres, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (UsernameNotFoundException e) {
            return new ResponseEntity(null, null, (HttpStatusCode)HttpStatus.CONFLICT);
        }
    }

    public LoginREST(UserRepository userRepo, AuthenticationService authService) {
        this.userRepo = userRepo;
        this.authService = authService;
    }
}

